#!/bin/bash
set -e
BASE_DIR="$(cd "$(dirname "$0")" && pwd)"
cd "$BASE_DIR"

# create venv if missing
if [ ! -d "venv" ]; then
  python3 -m venv venv
fi

source venv/bin/activate
pip install --upgrade pip
pip install -r requirements.txt

# load env
if [ -f ".env" ]; then
  set -o allexport
  source .env
  set +o allexport
fi

# start agent
python3 agent.py dev