# agent.py — LiveKit Agents 1.2.x (vision + BVC + prompts + ALL_TOOLS + auto-followup)
import logging
from dotenv import load_dotenv

# Load env early so plugins/tooling see keys
load_dotenv()

from livekit import agents
from livekit.agents import AgentSession, Agent, RoomInputOptions
from livekit.plugins import openai, noise_cancellation

# Prompts
from prompts import AGENT_INSTRUCTION, SESSION_INSTRUCTION

# One-stop tool bundle (core + Google + Perfex) 
from tools_info import ALL_TOOLS

LOG = logging.getLogger("jarvis-agent")
logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s - %(levelname)s %(name)s - %(message)s",
)

async def entrypoint(ctx: agents.JobContext):
    LOG.info("Connecting to LiveKit…")
    await ctx.connect()  # must happen before session.start

    # Realtime multimodal (voice+vision)
    session = AgentSession(
        llm=openai.realtime.RealtimeModel(voice="verse")
    )

    jarvis = Agent(
        instructions=AGENT_INSTRUCTION.strip(),
        tools=ALL_TOOLS,  # everything aggregated in tools_info.py
    )

    await session.start(
        room=ctx.room,
        agent=jarvis,
        room_input_options=RoomInputOptions(
            video_enabled=True,                         # vision ON
            noise_cancellation=noise_cancellation.BVC(),  # LiveKit Cloud BVC
            close_on_disconnect=False,                  # keep session stable
        ),
    )


    # brief first turn
    try:
        await session.generate_reply(instructions=SESSION_INSTRUCTION.strip())
    except AttributeError:
        LOG.info("generate_reply not available; skipping initial prompt.")

if __name__ == "__main__":
    agents.cli.run_app(agents.WorkerOptions(entrypoint_fnc=entrypoint))